<?php

namespace App\Http\Controllers;

use App\Models\Facade\FaturamentoDB;
use App\Models\Facade\PedidosDB;

class DashboardController extends Controller
{
    public function index()
    {
        return view('dashboard.index');
    }

    public function pedidosPorHora($data)
    {
        $pedidos = PedidosDB::totalDePedidosAgrupadoPorHora($data);
        $maior = $pedidos->max('total_pedidos');
        return response()->json(['pedidos' => $pedidos, 'maior' => $maior]);
    }

    public function recargasPorHora($data)
    {
        $pedidos = FaturamentoDB::totalDeRecargasAgrupadasPorHora($data);
        $maior = $pedidos->max('total_recargas');
        return response()->json(['recargas' => $pedidos, 'maior' => $maior]);
    }
}

